/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.monitor;

import com.ibm.hwmca.base.monitor.ObjectWrapper;
import com.ibm.hwmca.base.util.IssueCmd;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class MonitorUtils {
    private static final String TRACE_MASKD = "XMONUTLD";
    private static final String TRACE_MASKF = "XMONUTLF";
    private static final String TRACE_MASKT = "XMONUTLT";

    public static void main(String[] args) {
    }

    public static int execute(String command, ObjectWrapper stdOutWrapper, ObjectWrapper stdErrWrapper) {
        IssueCmd issueCmd = null;
        int result = 0;
        Trace.trace(TRACE_MASKT, "-> execute( " + command + ", " + stdOutWrapper + ", " + stdErrWrapper + ")");
        issueCmd = new IssueCmd();
        result = issueCmd.execute(command);
        if (stdOutWrapper != null) {
            stdOutWrapper.setObject(issueCmd.getOutput());
        }
        if (stdErrWrapper != null) {
            stdErrWrapper.setObject(issueCmd.getErrorOutput());
        }
        Trace.trace(TRACE_MASKT, "<- execute(...) returning " + result);
        return result;
    }

    public static int execute(String[] command, ObjectWrapper stdOutWrapper, ObjectWrapper stdErrWrapper) {
        IssueCmd issueCmd = null;
        int result = 0;
        Trace.trace(TRACE_MASKT, "-> execute( " + command + ", " + stdOutWrapper + ", " + stdErrWrapper + ")");
        issueCmd = new IssueCmd();
        result = issueCmd.execute(command);
        if (stdOutWrapper != null) {
            stdOutWrapper.setObject(issueCmd.getOutput());
        }
        if (stdErrWrapper != null) {
            stdErrWrapper.setObject(issueCmd.getErrorOutput());
        }
        Trace.trace(TRACE_MASKT, "<- execute(...) returning " + result);
        return result;
    }

    public static String[] getLines(String lines) {
        String[] result = null;
        StringTokenizer st = null;
        ArrayList<Object> stagingArea = null;
        if (lines != null) {
            stagingArea = new ArrayList<Object>();
            st = new StringTokenizer(lines, "\n");
            while (st.hasMoreElements()) {
                stagingArea.add(st.nextElement());
            }
            if (stagingArea.size() > 0) {
                result = stagingArea.toArray(new String[stagingArea.size()]);
            }
        }
        return result;
    }

    public static String getWordXFromRight(String words, int wordNumToGet) {
        String result = null;
        StringTokenizer st = null;
        int numOfWords = 0;
        if (words != null && wordNumToGet > 0 && (numOfWords = (st = new StringTokenizer(words, " ")).countTokens()) >= wordNumToGet) {
            for (int i = 0; i < numOfWords - wordNumToGet; ++i) {
                st.nextToken();
            }
            result = st.nextToken();
        }
        return result;
    }

    public static int getIndexWordX(String words, int wordNumToGet) {
        return MonitorUtils.getIndexTokenX(words, wordNumToGet, " \t\n\r\f");
    }

    public static String getWordX(String words, int wordNumToGet) {
        return MonitorUtils.getTokenX(words, wordNumToGet, " \t\n\r\f");
    }

    public static String getTokenX(String inString, int tokenNum, String delimiters) {
        String result = null;
        StringTokenizer st = null;
        int i = 0;
        String token = null;
        if (inString != null && tokenNum > 0) {
            st = new StringTokenizer(inString, delimiters);
            for (i = 0; i < tokenNum && st.hasMoreElements(); ++i) {
                token = (String)st.nextElement();
            }
            if (i == tokenNum) {
                result = token;
            }
        }
        return result;
    }

    public static int getIndexTokenX(String inString, int tokenNum, String delimiters) {
        int result = -1;
        int curIndex = 0;
        int inStringLength = 0;
        boolean found = false;
        int delimiterIndex = 0;
        int numDelimiters = 0;
        inStringLength = inString.length();
        if (inString != null && tokenNum > 0 && delimiters != null && delimiters.length() > 0) {
            curIndex = 0;
            numDelimiters = delimiters.length();
            block0: for (int tokenIndex = 1; tokenIndex <= tokenNum && curIndex < inStringLength; ++tokenIndex) {
                while (curIndex < inStringLength && delimiters.indexOf(inString.charAt(curIndex)) != -1) {
                    ++curIndex;
                }
                if (curIndex >= inStringLength) continue;
                if (tokenIndex == tokenNum) {
                    result = curIndex;
                    break;
                }
                while (curIndex < inStringLength) {
                    found = false;
                    for (int j = 0; j < numDelimiters; ++j) {
                        delimiterIndex = inString.indexOf(delimiters.charAt(j), curIndex);
                        if (delimiterIndex == -1) continue;
                        curIndex = delimiterIndex;
                        found = true;
                        break;
                    }
                    if (found) continue block0;
                    ++curIndex;
                }
            }
        }
        return result;
    }

    public static String replaceAll(String inString, String fromPiece, String toPiece) {
        String result = null;
        StringBuffer resultBuffer = null;
        int index = 0;
        int currentIndex = 0;
        int inStringLength = 0;
        Trace.trace(TRACE_MASKT, "-> replaceAll( " + inString + ", " + fromPiece + ", " + toPiece + ")");
        if (fromPiece == null || fromPiece.length() == 0) {
            throw new IllegalArgumentException("fromPiece is null");
        }
        if (toPiece == null) {
            throw new IllegalArgumentException("toPiece is null");
        }
        result = inString;
        if (inString != null) {
            block5: {
                inStringLength = inString.length();
                currentIndex = 0;
                resultBuffer = new StringBuffer();
                while ((index = inString.indexOf(fromPiece, currentIndex)) != -1) {
                    resultBuffer.append(inString.substring(currentIndex, index));
                    resultBuffer.append(toPiece);
                    currentIndex = index + fromPiece.length();
                    if (currentIndex < inString.length()) continue;
                    break block5;
                }
                if (inStringLength - currentIndex > 0) {
                    resultBuffer = resultBuffer.append(inString.substring(currentIndex, inStringLength));
                }
            }
            result = resultBuffer.toString();
        }
        Trace.trace(TRACE_MASKT, "<- replaceAll(...) returning " + result);
        return result;
    }

    static Properties createProperties(String arg) throws HException {
        Properties result = null;
        result = new Properties();
        try {
            result.load(new ByteArrayInputStream(arg.getBytes("ISO8859_1")));
        }
        catch (UnsupportedEncodingException e) {
            Trace.trace(TRACE_MASKF, "UnsupportedEncodingException : " + e.toString());
            throw new HException(e);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException : " + e.toString());
            throw new HException(e);
        }
        return result;
    }

    public static String[] splitUp(String inString) {
        String[] result = null;
        StringTokenizer st = null;
        ArrayList<String> stagingArea = null;
        String token = null;
        boolean insideQuote = false;
        Trace.trace(TRACE_MASKT, "-> splitUp( " + inString + ")");
        if (inString != null) {
            stagingArea = new ArrayList<String>();
            st = new StringTokenizer(inString.trim(), " '", true);
            while (st.hasMoreElements()) {
                token = insideQuote ? st.nextToken("'") : st.nextToken();
                if (token.equals("'")) {
                    if (insideQuote) {
                        insideQuote = false;
                        continue;
                    }
                    insideQuote = true;
                    continue;
                }
                if (token.equals(" ")) continue;
                stagingArea.add(token);
            }
        }
        if ((result = stagingArea.toArray(new String[stagingArea.size()])) == null) {
            Trace.trace(TRACE_MASKT, "<- splitUp(...) returning null");
        } else {
            Trace.trace(TRACE_MASKT, "<- splitUp(...) returning:");
            for (int i = 0; i < result.length; ++i) {
                Trace.trace(TRACE_MASKT, result[i]);
            }
        }
        return result;
    }
}

